<?php

namespace App\Classes;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Game extends Model 
{

    protected $table = 'games';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function location()
    {
        return $this->hasOne('App\Classes\Location');
    }

    public function teams()
    {
        return $this->belongsToMany('App\Classes\Team');
    }

    public function profiles()
    {
        return $this->belongsToMany('App\Classes\Profile');
    }

}